import { world, ItemStack, GameMode } from '@minecraft/server'

const toolTypeIds = [
    'v360:emerald_axe',
    'v360:emerald_pickaxe',
    'v360:emerald_shovel',
    'v360:emerald_hoe',
    'v360:amethyst_crusher_pickaxe',
    'v360:citrine_crusher_pickaxe',
    'v360:garnet_crusher_pickaxe',
    'v360:jade_crusher_pickaxe'
];

const weaponTypeIds = [
    'v360:emerald_sword',
    'v360:jade_dagger'
];

world.afterEvents.playerBreakBlock.subscribe(evd => {
    const { player, itemStackBeforeBreak: itemUsed } = evd;
    if (!itemUsed || player.matches({ gameMode: GameMode.creative })) return;

    if (toolTypeIds.includes(itemUsed.typeId) || weaponTypeIds.includes(itemUsed.typeId)) {
        const playerEquippableComp = player.getComponent("equippable");
        if (!playerEquippableComp) return;
        const itemEnchantmentComp = itemUsed.getComponent("minecraft:enchantable");
        const unbreakingLevel = itemEnchantmentComp?.getEnchantment("unbreaking")?.level ?? 0;
        const breakChance = 100 / (unbreakingLevel + 1);
        const randomizeChance = Math.random() * 100;
        if (breakChance < randomizeChance) return;
        const itemUsedDurabilityComp = itemUsed.getComponent("durability");
        if (!itemUsedDurabilityComp) return;

        let durabilityModifier = 0;
        if (toolTypeIds.includes(itemUsed.typeId)) {
            durabilityModifier = 1;
        } else {
            durabilityModifier = 2;
        }
        const maxDurability = itemUsedDurabilityComp.maxDurability
        const currentDamage = itemUsedDurabilityComp.damage
        if (currentDamage >= maxDurability) {
            player.playSound('random.break', { pitch: 1, location: player.location, volume: 1 })
            playerEquippableComp.setEquipment("Mainhand", new ItemStack('minecraft:air', 1));
        }
        else if (currentDamage < maxDurability) {
            itemUsedDurabilityComp.damage += durabilityModifier;
            playerEquippableComp.setEquipment("Mainhand", itemUsed);
        }
    }
})